/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClassEntry;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class ObjectStreamClass
implements Serializable {
    private static final int M_TRANSIENT = 128;
    private static final int M_PRIVATE = 2;
    private static final int M_STATIC = 8;
    private static ObjectStreamClassEntry[] descriptorFor = new ObjectStreamClassEntry[61];
    private String name;
    private ObjectStreamClass superclass;
    private boolean serializable;
    private boolean externalizable;
    private ObjectStreamField[] fields;
    private Class ofClass;
    private long suid;
    private int[] fieldSequence;
    private boolean hasWriteObjectMethod;
    private ObjectStreamClass localClassDesc;
    private static Class classSerializable = null;
    private static Class classExternalizable = null;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ObjectStreamClass lookup(Class clazz) {
        ObjectStreamClass objectStreamClass = null;
        ObjectStreamClassEntry[] objectStreamClassEntryArray = descriptorFor;
        synchronized (objectStreamClassEntryArray) {
            objectStreamClass = ObjectStreamClass.findDescriptorFor(clazz);
            if (objectStreamClass != null) {
                return objectStreamClass;
            }
            boolean bl = classSerializable.isAssignableFrom(clazz);
            if (!bl) {
                return null;
            }
            boolean bl2 = classExternalizable.isAssignableFrom(clazz);
            if (bl2) {
                bl = false;
            }
            ObjectStreamClass objectStreamClass2 = null;
            if (!bl) return new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
            Class clazz2 = clazz.getSuperclass();
            if (clazz2 == null) return new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
            objectStreamClass2 = ObjectStreamClass.lookup(clazz2);
            return new ObjectStreamClass(clazz, objectStreamClass2, bl, bl2);
        }
    }

    public String getName() {
        return this.name;
    }

    public long getSerialVersionUID() {
        return this.suid;
    }

    public Class forClass() {
        return this.ofClass;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append(": static final long serialVersionUID = ");
        stringBuffer.append(Long.toString(this.suid));
        stringBuffer.append("L;");
        return stringBuffer.toString();
    }

    private ObjectStreamClass(Class clazz, ObjectStreamClass objectStreamClass, boolean bl, boolean bl2) {
        this.ofClass = clazz;
        this.name = clazz.getName();
        this.superclass = objectStreamClass;
        this.serializable = bl;
        this.externalizable = bl2;
        ObjectStreamClass.insertDescriptorFor(this);
        if (this.externalizable || this.name.equals("java.lang.String")) {
            this.fields = new ObjectStreamField[0];
        } else {
            this.fields = this.getFields0(clazz);
            if (this.fields.length > 0) {
                boolean bl3;
                do {
                    bl3 = true;
                    int n = this.fields.length - 1;
                    while (n > 0) {
                        if (this.fields[n - 1].compare(this.fields[n]) > 0) {
                            ObjectStreamField objectStreamField = this.fields[n];
                            this.fields[n] = this.fields[n - 1];
                            this.fields[n - 1] = objectStreamField;
                            bl3 = false;
                        }
                        --n;
                    }
                } while (!bl3);
                this.computeFieldSequence();
            }
        }
        this.suid = ObjectStreamClass.getSerialVersionUID(clazz);
        if (this.suid == 0L) {
            this.suid = ObjectStreamClass.computeSerialVersionUID(clazz);
        }
        this.hasWriteObjectMethod = ObjectStreamClass.hasWriteObject(clazz);
    }

    ObjectStreamClass(String string, long l) {
        this.name = string;
        this.suid = l;
        this.superclass = null;
    }

    void setClass(Class clazz) throws InvalidClassException {
        if (clazz == null) {
            this.localClassDesc = null;
            this.ofClass = null;
            int n = 0;
            while (n < this.fields.length) {
                this.fields[n].offset = -1;
                ++n;
            }
            this.computeFieldSequence();
            return;
        }
        this.localClassDesc = ObjectStreamClass.lookup(clazz);
        if (!clazz.getName().equals(this.name) || this.suid != this.localClassDesc.suid) {
            throw new InvalidClassException(clazz.getName(), "Local class not compatible");
        }
        if (this.serializable != this.localClassDesc.serializable || this.externalizable != this.localClassDesc.externalizable) {
            throw new InvalidClassException(clazz.getName(), "Serialization incompatible with Externalization");
        }
        ObjectStreamField[] objectStreamFieldArray = this.localClassDesc.getFields();
        ObjectStreamField[] objectStreamFieldArray2 = this.fields;
        int n = 0;
        int n2 = 0;
        while (n2 < objectStreamFieldArray2.length) {
            block8: {
                int n3 = n;
                while (n3 < objectStreamFieldArray.length) {
                    if (objectStreamFieldArray2[n2].name.equals(objectStreamFieldArray[n3].name)) {
                        if (!objectStreamFieldArray2[n2].typeEquals(objectStreamFieldArray[n3])) {
                            throw new InvalidClassException(clazz.getName(), "The type of field " + objectStreamFieldArray2[n2].name + " of class " + this.name + " is incompatible.");
                        }
                        n = n3;
                        objectStreamFieldArray2[n2].offset = objectStreamFieldArray[n].offset;
                        break block8;
                    }
                    ++n3;
                }
                objectStreamFieldArray2[n2].offset = -1;
            }
            ++n2;
        }
        this.computeFieldSequence();
        this.ofClass = clazz;
    }

    boolean typeEquals(ObjectStreamClass objectStreamClass) {
        return this.suid == objectStreamClass.suid && this.name.equals(objectStreamClass.name);
    }

    ObjectStreamField[] getFields() {
        return this.fields;
    }

    void setSuperclass(ObjectStreamClass objectStreamClass) {
        this.superclass = objectStreamClass;
    }

    ObjectStreamClass getSuperclass() {
        return this.superclass;
    }

    boolean hasWriteObject() {
        return this.hasWriteObjectMethod;
    }

    ObjectStreamClass localClassDescriptor() {
        return this.localClassDesc;
    }

    boolean isExternalizable() {
        return this.externalizable;
    }

    int[] getFieldSequence() {
        return this.fieldSequence;
    }

    private void computeFieldSequence() {
        this.fieldSequence = new int[this.fields.length * 2];
        int n = 0;
        while (n < this.fields.length) {
            this.fieldSequence[n * 2] = this.fields[n].type;
            this.fieldSequence[n * 2 + 1] = this.fields[n].offset;
            ++n;
        }
    }

    private static long computeSerialVersionUID(Class clazz) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(512);
        long l = 0L;
        try {
            int n;
            Object object;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA");
            DigestOutputStream digestOutputStream = new DigestOutputStream(byteArrayOutputStream, messageDigest);
            DataOutputStream dataOutputStream = new DataOutputStream(digestOutputStream);
            dataOutputStream.writeUTF(clazz.getName());
            int n2 = ObjectStreamClass.getClassAccess(clazz);
            dataOutputStream.writeInt(n2 &= 0x611);
            Object[] objectArray = clazz.getInterfaces();
            ObjectStreamClass.quicksort(objectArray);
            int n3 = 0;
            while (n3 < objectArray.length) {
                dataOutputStream.writeUTF(((Class)objectArray[n3]).getName());
                ++n3;
            }
            Object[] objectArray2 = ObjectStreamClass.getFieldSignatures(clazz);
            ObjectStreamClass.quicksort(objectArray2);
            int n4 = 0;
            while (n4 < objectArray2.length) {
                object = objectArray2[n4];
                n = ObjectStreamClass.getFieldAccess(clazz, (String)object);
                if ((n & 2) != 2 || (n & 0x80) != 128 && (n & 8) != 8) {
                    int n5 = ((String)object).indexOf(32);
                    String string = ((String)object).substring(0, n5);
                    String string2 = ((String)object).substring(n5 + 1);
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeInt(n);
                    dataOutputStream.writeUTF(string2);
                }
                ++n4;
            }
            object = ObjectStreamClass.getMethodSignatures(clazz);
            ObjectStreamClass.quicksort((Object[])object);
            n = 0;
            while (n < ((Object[])object).length) {
                Object object2 = object[n];
                int n6 = ObjectStreamClass.getMethodAccess(clazz, (String)object2);
                if ((n6 & 2) == 0) {
                    int n7 = ((String)object2).indexOf(32);
                    String string = ((String)object2).substring(0, n7);
                    String string3 = ((String)object2).substring(n7 + 1);
                    string3 = string3.replace('/', '.');
                    dataOutputStream.writeUTF(string);
                    dataOutputStream.writeInt(n6);
                    dataOutputStream.writeUTF(string3);
                }
                ++n;
            }
            byte[] byArray = messageDigest.digest();
            int n8 = 0;
            while (n8 < Math.min(8, byArray.length)) {
                l += (long)(byArray[n8] & 0xFF) << n8 * 8;
                ++n8;
            }
        }
        catch (IOException iOException) {
            l = -1L;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new SecurityException(noSuchAlgorithmException.getMessage());
        }
        return l;
    }

    private static native int getClassAccess(Class var0);

    private static native String[] getMethodSignatures(Class var0);

    private static native int getMethodAccess(Class var0, String var1);

    private static native String[] getFieldSignatures(Class var0);

    private static native int getFieldAccess(Class var0, String var1);

    void write(ObjectOutputStream objectOutputStream) throws IOException {
        int n = 0;
        if (this.hasWriteObjectMethod) {
            n |= 1;
        }
        if (this.serializable) {
            n |= 2;
        }
        if (this.externalizable) {
            n |= 4;
        }
        objectOutputStream.writeByte(n);
        objectOutputStream.writeShort(this.fields.length);
        int n2 = 0;
        while (n2 < this.fields.length) {
            ObjectStreamField objectStreamField = this.fields[n2];
            objectOutputStream.writeByte(objectStreamField.type);
            objectOutputStream.writeUTF(objectStreamField.name);
            if (!objectStreamField.isPrimitive()) {
                objectOutputStream.writeObject(objectStreamField.typeString);
            }
            ++n2;
        }
    }

    void read(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        byte by = objectInputStream.readByte();
        this.hasWriteObjectMethod = (by & 1) != 0;
        this.serializable = (by & 2) != 0;
        this.externalizable = (by & 4) != 0;
        int n = objectInputStream.readShort();
        this.fields = new ObjectStreamField[n];
        int n2 = 0;
        while (n2 < n) {
            char c = (char)objectInputStream.readByte();
            String string = objectInputStream.readUTF();
            String string2 = null;
            if (c == '[' || c == 'L') {
                string2 = (String)objectInputStream.readObject();
            }
            this.fields[n2] = new ObjectStreamField(string, c, -1, string2);
            ++n2;
        }
    }

    private static ObjectStreamClass findDescriptorFor(Class clazz) {
        ObjectStreamClassEntry objectStreamClassEntry;
        int n = clazz.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        while ((objectStreamClassEntry = descriptorFor[n2]) != null && objectStreamClassEntry.check() == null) {
            ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry.next;
        }
        ObjectStreamClassEntry objectStreamClassEntry2 = objectStreamClassEntry;
        while (objectStreamClassEntry != null) {
            ObjectStreamClass objectStreamClass = (ObjectStreamClass)objectStreamClassEntry.check();
            if (objectStreamClass == null) {
                objectStreamClassEntry2.next = objectStreamClassEntry.next;
            } else {
                if (objectStreamClass.ofClass == clazz) {
                    return objectStreamClass;
                }
                objectStreamClassEntry2 = objectStreamClassEntry;
            }
            objectStreamClassEntry = objectStreamClassEntry.next;
        }
        return null;
    }

    private static void insertDescriptorFor(ObjectStreamClass objectStreamClass) {
        if (ObjectStreamClass.findDescriptorFor(objectStreamClass.ofClass) != null) {
            return;
        }
        int n = objectStreamClass.ofClass.hashCode();
        int n2 = (n & Integer.MAX_VALUE) % descriptorFor.length;
        ObjectStreamClassEntry objectStreamClassEntry = new ObjectStreamClassEntry();
        objectStreamClassEntry.setThing(objectStreamClass);
        objectStreamClassEntry.next = descriptorFor[n2];
        ObjectStreamClass.descriptorFor[n2] = objectStreamClassEntry;
    }

    private native ObjectStreamField[] getFields0(Class var1);

    private static native long getSerialVersionUID(Class var0);

    private static native boolean hasWriteObject(Class var0);

    private static int doCompare(Object object, Object object2) {
        String string;
        String string2;
        if (object instanceof String && object2 instanceof String) {
            string2 = (String)object;
            string = (String)object2;
        } else if (object instanceof Class && object2 instanceof Class) {
            Class clazz = (Class)object;
            Class clazz2 = (Class)object2;
            string2 = clazz.getName();
            string = clazz2.getName();
        } else if (object instanceof ObjectStreamField && object2 instanceof ObjectStreamField) {
            ObjectStreamField objectStreamField = (ObjectStreamField)object;
            ObjectStreamField objectStreamField2 = (ObjectStreamField)object2;
            string2 = objectStreamField.name;
            string = objectStreamField2.name;
        } else {
            throw new Error("Unsupported types");
        }
        return string2.compareTo(string);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void quicksort(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        ObjectStreamClass.swap(objectArray, n, (n + n2) / 2);
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (ObjectStreamClass.doCompare(objectArray[n4], objectArray[n]) < 0) {
                ObjectStreamClass.swap(objectArray, ++n3, n4);
            }
            ++n4;
        }
        ObjectStreamClass.swap(objectArray, n, n3);
        ObjectStreamClass.quicksort(objectArray, n, n3 - 1);
        ObjectStreamClass.quicksort(objectArray, n3 + 1, n2);
    }

    private static void quicksort(Object[] objectArray) {
        ObjectStreamClass.quicksort(objectArray, 0, objectArray.length - 1);
    }

    static {
        try {
            classSerializable = Class.forName("java.io.Serializable");
            classExternalizable = Class.forName("java.io.Externalizable");
        }
        catch (Throwable throwable) {
            System.err.println("Could not load java.io.Serializable or java.io.Externalizable.");
        }
    }
}

