/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Font;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.event.ActionEvent;
import java.awt.peer.MenuItemPeer;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WObjectPeer;
import sun.awt.windows.WToolkit;

class WMenuItemPeer
extends WObjectPeer
implements MenuItemPeer {
    String shortcutLabel;
    boolean isCheckbox = false;
    private static Font defaultMenuFont;

    public void dispose() {
        WToolkit.targetDisposedPeer(this.target, this);
        this._dispose();
    }

    public void setEnabled(boolean bl) {
        this.enable(bl);
    }

    public void enable() {
        this.enable(true);
    }

    public void disable() {
        this.enable(false);
    }

    public void setLabel(String string) {
        MenuShortcut menuShortcut = ((MenuItem)this.target).getShortcut();
        this.shortcutLabel = menuShortcut != null ? menuShortcut.toString() : null;
        this._setLabel(string);
    }

    public native void _setLabel(String var1);

    protected WMenuItemPeer() {
    }

    WMenuItemPeer(MenuItem menuItem) {
        this.target = menuItem;
        WMenuPeer wMenuPeer = (WMenuPeer)WToolkit.targetToPeer(menuItem.getParent());
        this.create(wMenuPeer);
        MenuShortcut menuShortcut = menuItem.getShortcut();
        if (menuShortcut != null) {
            this.shortcutLabel = menuShortcut.toString();
        }
    }

    native void create(WMenuPeer var1);

    native void enable(boolean var1);

    public native void _dispose();

    protected void finalize() throws Throwable {
        this._dispose();
        super.finalize();
    }

    void handleAction(int n) {
        WToolkit.postEvent(new ActionEvent(this.target, 1001, ((MenuItem)this.target).getActionCommand(), n));
    }

    Font getDefaultFont() {
        return defaultMenuFont;
    }

    static {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("sun.awt.windows.awtLocalization");
            defaultMenuFont = Font.decode(resourceBundle.getString("menuFont"));
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println(missingResourceException.getMessage());
            System.out.println("Using default MenuItem font\n");
            defaultMenuFont = new Font("SanSerif", 0, 11);
        }
    }
}

