/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.pagemill.embeddedapplet;

import com.adobe.pagemill.embeddedapplet.AppletAudioClip;
import com.adobe.pagemill.embeddedapplet.AppletClassEntry;
import com.adobe.pagemill.embeddedapplet.AppletClassLoader;
import com.adobe.pagemill.embeddedapplet.AppletImageRef;
import java.applet.AudioClip;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.security.Identity;
import java.security.IdentityScope;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import sun.misc.Ref;
import sun.tools.jar.JarImageSource;
import sun.tools.jar.JarVerifierStream;

public class AppletResourceLoader {
    static boolean debug;
    static boolean verboseResourceLoading;
    private static Hashtable imgHash;
    private static Hashtable audioHash;
    private static Hashtable resourceHash;
    private static Hashtable mimeHash;
    AppletClassLoader loader;
    IdentityScope scope;

    private void verbose(String string) {
        if (verboseResourceLoading) {
            System.out.println(string);
        }
    }

    static void debug(String string) {
        if (debug) {
            System.out.println(string);
        }
    }

    static void debug(String string, Throwable throwable) {
        if (debug) {
            throwable.printStackTrace();
        }
        System.out.println("sun.applet.AppletResourceLoader:::" + string);
    }

    public AppletResourceLoader(AppletClassLoader appletClassLoader) {
        this.loader = appletClassLoader;
        this.scope = IdentityScope.getSystemScope();
    }

    void loadJar(URL uRL, String string) throws IOException {
        AppletResourceLoader.debug("jarLoader: loading jar " + uRL + "/" + string);
        URL uRL2 = new URL(uRL, string);
        JarVerifierStream jarVerifierStream = null;
        Hashtable<Object, Image> hashtable = new Hashtable<Object, Image>();
        try {
            try {
                Object object;
                jarVerifierStream = new JarVerifierStream(uRL2.openStream());
                ZipEntry zipEntry = null;
                while ((zipEntry = jarVerifierStream.getNextEntry()) != null) {
                    Object object2;
                    object = zipEntry.getName();
                    String string2 = null;
                    Object object3 = null;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    AppletResourceLoader.debug("loading: " + (String)object + "...");
                    BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)jarVerifierStream);
                    int n = bufferedInputStream.read();
                    while (n != -1) {
                        byteArrayOutputStream.write(n);
                        n = bufferedInputStream.read();
                    }
                    AppletResourceLoader.debug("done loading: " + (String)object + ".");
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    if (string2 == null) {
                        string2 = this.guessManifestType((String)object);
                    }
                    if (string2 == null) {
                        object2 = new ByteArrayInputStream(byArray);
                        string2 = URLConnection.guessContentTypeFromStream((InputStream)object2);
                    }
                    if (string2 == null) {
                        string2 = "input-stream/input-stream";
                    }
                    AppletResourceLoader.debug("loading " + (String)object + " (most likely guessed mime-type: " + string2 + ")");
                    if (string2.startsWith("image")) {
                        this.putLocalResource(new URL(uRL, (String)object), byArray, string2);
                        object3 = this.createImage(byArray, uRL, (String)object, string2);
                    } else if (string2.startsWith("audio")) {
                        object2 = new URL(uRL, (String)object);
                        this.putLocalResource((URL)object2, byArray, string2);
                        AppletAudioClip appletAudioClip = new AppletAudioClip(byArray);
                        audioHash.put(object2, appletAudioClip);
                        object3 = appletAudioClip;
                    } else if (string2.startsWith("input-stream")) {
                        this.putLocalResource(new URL(uRL, (String)object), byArray, string2);
                        object3 = object2 = new ByteArrayInputStream(byArray);
                    } else if (string2.startsWith("application/java-vm")) {
                        this.putLocalResource(new URL(uRL, (String)object), byArray, string2);
                        object2 = ((String)object).substring(0, ((String)object).length() - 6).replace('/', '.');
                        object3 = this.loader.defineClassFromBytes((String)object2, byArray, 0, byArray.length);
                    } else if (!string2.equals("manifest/manifest") && !string2.equals("manifest/signature-bin")) {
                        AppletResourceLoader.debug("ZipEntry " + (String)object + " has unsupported mimetype " + string2);
                    }
                    if (object3 == null) continue;
                    hashtable.put(object, (Image)object3);
                    object3 = null;
                }
                object = jarVerifierStream.getBlocks();
                jarVerifierStream.getNameToHash();
                jarVerifierStream.getManifest();
                if (object != null) {
                    this.signObjects(jarVerifierStream.getVerifiedSignatures(), hashtable);
                } else {
                    AppletResourceLoader.debug("BLOCK is null");
                }
            }
            catch (IOException iOException) {
                AppletResourceLoader.debug("IOException loading archive: " + iOException);
                iOException.printStackTrace();
            }
            Object var7_17 = null;
        }
        catch (Throwable throwable) {
            block21: {
                Object var7_18 = null;
                AppletResourceLoader.debug("Closing jar input stream");
                if (jarVerifierStream == null) break block21;
                jarVerifierStream.close();
            }
            throw throwable;
        }
        AppletResourceLoader.debug("Closing jar input stream");
        if (jarVerifierStream != null) {
            jarVerifierStream.close();
        }
    }

    private void signObjects(Hashtable hashtable, Hashtable hashtable2) {
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            AppletClassEntry appletClassEntry;
            String string = (String)enumeration.nextElement();
            Vector vector = (Vector)hashtable.get(string);
            Object v = hashtable2.get(string);
            Object[] objectArray = new Identity[vector.size()];
            vector.copyInto(objectArray);
            if (!(v instanceof AppletClassEntry) || (appletClassEntry = (AppletClassEntry)this.loader.rawClasses.get(v)) == null || appletClassEntry != v) continue;
            appletClassEntry.ids = objectArray;
        }
    }

    String guessManifestType(String string) {
        if ((string = string.toUpperCase()).startsWith("/")) {
            string = string.substring(1);
        }
        if (!string.startsWith("META-INF/")) {
            return null;
        }
        if (string.equalsIgnoreCase("META-INF/MANIFEST.MF")) {
            return "manifest/manifest";
        }
        if (string.endsWith("DSA") || string.endsWith("PK7") || string.endsWith("PGP")) {
            return "manifest/signature-bin";
        }
        if (string.endsWith("SF")) {
            return "manifest/signature-asc";
        }
        return null;
    }

    static synchronized AudioClip getAudioClip(URL uRL) {
        System.getSecurityManager().checkConnect(uRL.getHost(), uRL.getPort());
        AudioClip audioClip = (AudioClip)audioHash.get(uRL);
        if (audioClip == null) {
            audioClip = new AppletAudioClip(uRL);
            audioHash.put(uRL, audioClip);
        }
        return audioClip;
    }

    Image createImage(byte[] byArray, URL uRL, String string, String string2) throws MalformedURLException {
        AppletResourceLoader.debug("creating image: " + string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        JarImageSource jarImageSource = new JarImageSource(uRL, (InputStream)bufferedInputStream, string2);
        Image image = Toolkit.getDefaultToolkit().createImage((ImageProducer)jarImageSource);
        URL uRL2 = new URL(uRL, string);
        AppletImageRef appletImageRef = new AppletImageRef(uRL2);
        appletImageRef.setThing(image);
        imgHash.put(uRL2, appletImageRef);
        return image;
    }

    public static synchronized Image getImage(URL uRL) {
        return (Image)AppletResourceLoader.getImageRef(uRL).get();
    }

    public static synchronized Ref getImageRef(URL uRL) {
        AppletImageRef appletImageRef = (AppletImageRef)((Object)imgHash.get(uRL));
        if (appletImageRef == null) {
            appletImageRef = new AppletImageRef(uRL);
            imgHash.put(uRL, appletImageRef);
        }
        return appletImageRef;
    }

    public static void flushImages() {
        imgHash = new Hashtable();
    }

    void putLocalResource(URL uRL, byte[] byArray, String string) {
        resourceHash.put(uRL, byArray);
        mimeHash.put(uRL, string);
    }

    public static synchronized Object getLocalResource(URL uRL) {
        Object v = mimeHash.get(uRL);
        if (v == null) {
            return null;
        }
        String string = (String)v;
        if (string.startsWith("audio") && (v = audioHash.get(uRL)) != null) {
            return v;
        }
        byte[] byArray = (byte[])resourceHash.get(uRL);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
        if (string.startsWith("image")) {
            JarImageSource jarImageSource = new JarImageSource(uRL, (InputStream)bufferedInputStream, string);
            return jarImageSource;
        }
        return bufferedInputStream;
    }

    public static InputStream getLocalResourceStream(URL uRL) {
        BufferedInputStream bufferedInputStream = null;
        Object v = resourceHash.get(uRL);
        bufferedInputStream = (BufferedInputStream)v;
        if (v != null) {
            byte[] byArray = (byte[])bufferedInputStream;
            bufferedInputStream = new BufferedInputStream(new ByteArrayInputStream(byArray));
            return bufferedInputStream;
        }
        return null;
    }

    public String getResourceAsName(String string) {
        URL uRL;
        this.verbose("AppletResourceLoader.getResourceAsName for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        Object v = resourceHash.get(uRL);
        if (v != null) {
            this.verbose("Found resource: " + string + " in some jar archive for base: " + uRL2);
            try {
                uRL = new URL("appletresource", uRL2.getHost(), uRL2.getPort(), "/" + uRL2.toExternalForm() + "/+/" + string);
                return uRL.toExternalForm();
            }
            catch (Exception exception) {
                this.verbose("Exception " + exception + " while building a resource URL");
                return null;
            }
        }
        return uRL.toExternalForm();
    }

    public InputStream getResourceAsStream(String string) {
        URL uRL;
        this.verbose("AppletResourceLoader.getResourceAsStream for name: " + string);
        URL uRL2 = this.loader.getCodeBase();
        try {
            uRL = new URL(uRL2, string);
        }
        catch (Exception exception) {
            return null;
        }
        InputStream inputStream = AppletResourceLoader.getLocalResourceStream(uRL);
        if (inputStream != null) {
            this.verbose("Found resource: " + string + " in jar archive file");
            return inputStream;
        }
        this.verbose("Opening stream to: " + uRL + " to get resource " + string);
        try {
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection instanceof HttpURLConnection) {
                HttpURLConnection httpURLConnection = (HttpURLConnection)uRLConnection;
                int n = httpURLConnection.getResponseCode();
                if (n == 200) {
                    inputStream = uRL.openStream();
                }
                if (n >= 400) {
                    inputStream = null;
                }
            } else {
                inputStream = uRL.openStream();
            }
        }
        catch (Exception exception) {
            return null;
        }
        return inputStream;
    }

    void resetLocalResources() {
        resourceHash.clear();
    }

    static {
        imgHash = new Hashtable();
        audioHash = new Hashtable();
        resourceHash = new Hashtable();
        mimeHash = new Hashtable();
    }
}

